<?php
// api/load.php
header('Content-Type: application/json');
require_once 'db.php';

try {
    // Always fetch ID 1 for this simple tracker
    $id = 1;

    $stmt = $pdo->prepare("SELECT data FROM progress WHERE id = :id LIMIT 1");
    $stmt->execute([':id' => $id]);
    $row = $stmt->fetch();

    if ($row) {
        // Output the raw JSON stored in the DB
        echo $row['data']; 
    } else {
        // No data found (first visit)
        echo json_encode(['progress' => [], 'meta' => ['new_user' => true]]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}
?>
